#include "blocks/pyramidtree.h"
void pyramidtree_init(Block * super) {
    super->random_a = land_rnd(- pi, pi);
}
void pyramidtree_tick(Block * super) {
    dialog_gnome(super);
    if (super->speech) {
        return ;
    }
    walker(super);
}
void walker(Block * super) {
    float dx = cos(super->random_a);
    float dz = sin(super->random_a);
    float rx = super->xs / 2;
    float rz = super->zs / 2;
    float cx = super->x + rx;
    float cz = super->z + rz;
    super->dx += dx / 2;
    super->dz += dz / 2;
    super->subframe++;
    super->random_a += land_rnd(- 0.01, 0.01);
    float y = check_ground(super, cx + rx * dx, cz + rz * dz);
    if (y < super->y - 1 || y > super->y + 1) {
        print("turn %.1f %.1f", y, super->y);
        super->random_a = land_rnd(- pi, pi);
        return ;
    }
    int angle = round(atan2(dx, dz) * 4 / pi);
    int frames = 5;
    if (super->block_type == Data_Pyramidtree) {
        frames = 7;
    }
    int f = (super->subframe / 4) % (frames + frames - 2);
    if (f >= frames) {
        f = frames + frames - 2 - f;
    }
    int dir = (angle + 6) % 8;
    if (dir >= 3) {
        super->flipped = 0;
        dir -= 3;
    }
    else {
        super->flipped = 1;
        dir = 3 - dir;
    }
    super->frame = dir * frames + f;
    block_tick(super);
}
